//OS version = ubuntu 16.04 LTS
//Scilab version 5.5.2

clear;
clc;

n=10;                       			 //Number of Elements

lambda=1;                     			 // defining λ

d1=lambda/4;                  			//distance between the dipoles d1= λ/4

k=(2*%pi)/lambda;      			//defining constant k=2 π/ λ

theta=0.0001:0.01:2*%pi;                		//theta varies from 0° to 360° 

beta=0;                        			//β=0

psi=k*d1*cos(theta)+beta;                		//Progressive Phase

AF=sin(n.*psi/2)./(n*sin(psi/2));        		//Expression for Array Factor

polarplot(theta,AF);               		 //plot for d1= λ/4

d2=lambda;                  			//distance between the dipoles d2= λ

psi=k*d2*cos(theta)+beta;                		//Progressive Phase

AF=sin(n.*psi/2)./(n*sin(psi/2));        		//Expression for Array Factor

xset('line style',3)

polarplot(theta,AF);                 		//plot for d2= λ

title("POLAR PLOT FOR ARRAY FACTOR PATTERN FOR N ELEMENT UNIFORM AMPLITUDE BROADSIDE ARRAY CASE: N=10, d= λ /4 and d= λ, β=0")

h1=legend(' d= λ /4',' d= λ ')

